/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network;

import com.tacz.guns.network.HandshakeNetworking;
import com.tacz.guns.network.NetworkClientInitializer;
import com.tacz.guns.network.packets.c2s.CraftC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerAimC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerBoltGunC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerDrawGunC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerFireSelectC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerMeleeC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerReloadGunC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerShootC2SPacket;
import com.tacz.guns.network.packets.c2s.PlayerZoomC2SPacket;
import com.tacz.guns.network.packets.c2s.RefitGunC2SPacket;
import com.tacz.guns.network.packets.c2s.UnloadAttachmentC2SPacket;
import com.tacz.guns.network.packets.c2s.handshake.AcknowledgeC2SPacket;
import com.tacz.guns.network.packets.s2c.handshake.SyncedEntityDataMappingS2CPacket;
import com.tacz.guns.util.EnvironmentUtil;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class NetworkHandler {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver(PlayerShootC2SPacket.TYPE, PlayerShootC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerReloadGunC2SPacket.TYPE, PlayerReloadGunC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerFireSelectC2SPacket.TYPE, PlayerFireSelectC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerAimC2SPacket.TYPE, PlayerAimC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerDrawGunC2SPacket.TYPE, PlayerDrawGunC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(CraftC2SPacket.TYPE, CraftC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerZoomC2SPacket.TYPE, PlayerZoomC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(RefitGunC2SPacket.TYPE, RefitGunC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerBoltGunC2SPacket.TYPE, PlayerBoltGunC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(UnloadAttachmentC2SPacket.TYPE, UnloadAttachmentC2SPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(PlayerMeleeC2SPacket.TYPE, PlayerMeleeC2SPacket::handle);
        HandshakeNetworking.register(AcknowledgeC2SPacket.ID, AcknowledgeC2SPacket.class);
        HandshakeNetworking.register(SyncedEntityDataMappingS2CPacket.TYPE, SyncedEntityDataMappingS2CPacket.class);
        if (EnvironmentUtil.isClient()) {
            NetworkClientInitializer.init();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static <T extends FabricPacket> void sendToServer(T message) {
        ClientPlayNetworking.send(message);
    }

    public static <T extends FabricPacket> void sendToClientPlayer(T message, class_1657 player) {
        ServerPlayNetworking.send((class_3222)((class_3222)player), message);
    }

    public static <T extends FabricPacket> void sendToTrackingEntityAndSelf(class_1297 centerEntity, T message) {
        ((class_3215)centerEntity.method_5770().method_8398()).method_18751(centerEntity, NetworkHandler.toVanillaPacket(message));
    }

    public static <T extends FabricPacket> void sendToAllPlayers(MinecraftServer server, T message) {
        server.method_3760().method_14581(NetworkHandler.toVanillaPacket(message));
    }

    public static <T extends FabricPacket> void sendToTrackingEntity(T message, class_1297 centerEntity) {
        ((class_3215)centerEntity.method_5770().method_8398()).method_18754(centerEntity, NetworkHandler.toVanillaPacket(message));
    }

    public static <T extends FabricPacket> void sendToDimension(T message, class_1297 centerEntity) {
        class_5321 dimension = centerEntity.method_37908().method_27983();
        MinecraftServer server = centerEntity.method_5682();
        if (server != null) {
            server.method_3760().method_14589(NetworkHandler.toVanillaPacket(message), dimension);
        }
    }

    public static <T extends FabricPacket> class_2596<class_2602> toVanillaPacket(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)packet.getType().getId(), (class_2540)buf);
    }
}

